﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="System.Collections.Generic" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Lista dokumentow nierozliczonych</title>
	<script runat="server">

			
		public enum TypDokumentów
		{
			Zobowiązania, Należności
		}


		public enum Zakres
		{
			Razem, Kontrahenci, Pracownicy, Urzędy
		}


		public class PrnParams : ActualContext
		{
			private Zakres zakres = Zakres.Kontrahenci;
			private TypDokumentów dokumenty = TypDokumentów.Należności;
			private RodzajDokumentów rodzaj = RodzajDokumentów.Razem;
			private Waluta waluta;
			private IPodmiotKasowy odk;
			private IPodmiotKasowy dok;
			private String konto = String.Empty;


			public PrnParams(Context context)
				: base(context)
			{
				this.waluta = WalutyModule.GetInstance(this).Waluty.PLN;
			}


			[Priority(1)]
			[Caption("Stan na dzień")]
			public override Date Aktualny
			{
				set { base.Aktualny = value; }
				get { return base.Aktualny; }
			}


			[Priority(2)]
			public Zakres Zakres
			{
				get { return zakres; }
				set
				{
					zakres = value;
					OnChanged(EventArgs.Empty);
				}
			}


			[Priority(3)]
			[Caption("Od kontrahenta")]
			public IPodmiotKasowy Od
			{
				get { return odk; }
				set
				{
					odk = value;
					OnChanged(EventArgs.Empty);
				}
			}


			[Priority(4)]
			[Caption("Do kontrahenta")]
			public IPodmiotKasowy Do
			{
				get { return dok; }
				set
				{
					dok = value;
					OnChanged(EventArgs.Empty);
				}
			}

			[Priority(5)]
			public TypDokumentów Dokumenty
			{
				get { return dokumenty; }
				set
				{
					dokumenty = value;
					OnChanged(EventArgs.Empty);
				}
			}

			
			[Priority(6)]
			[Caption("Rodzaj")]
			public RodzajDokumentów Rodzaj
			{
				get { return rodzaj; }
				set
				{
					rodzaj = value;
					OnChanged(EventArgs.Empty);
				}
			}

			
			[Priority(7)]
			[Required]
			public Waluta Waluta
			{
				get { return waluta; }
				set
				{
					waluta = value;
					OnChanged(EventArgs.Empty);
				}
			}


			[Priority(8)]
			public String Konto
			{
				get { return konto; }
				set
				{
					konto = value.ToUpper();
					OnChanged(EventArgs.Empty);
				}
			}


			public RowCondition Condition()
			{
				switch (zakres)
				{
					case Zakres.Kontrahenci:
						return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
					case Zakres.Pracownicy:
						return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
					case Zakres.Urzędy:
						RowCondition condition = RowCondition.Empty;
						condition = new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
						condition |= new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
						return new RowCondition.Not(condition);
					default:
						return RowCondition.Empty;
				}
			}
		}

		
		private PrnParams pars = null;
		private OdsetkiKarneParamsEx okPars = null;
		
		
		[Context(Required=true)]
		public PrnParams Params
		{
			get { return pars; }
			set { pars = value; }
		}


		[Context(Required = true)]
		public OdsetkiKarneParamsEx OkParams
		{
			get { return okPars; }
			set { okPars = value; }
		}


	    [Context(Required = true)]
	    public WydrukOddzialParams OParams { get; set; }


		private struct CustomerSelection
		{
			private String OdKodu;
			private String DoKodu;

			public void Init(IPodmiotKasowy podmiot1, IPodmiotKasowy podmiot2)
			{
				OdKodu = podmiot1 == null ? null : podmiot1.Kod.ToUpper();
				DoKodu = podmiot2 == null ? null : podmiot2.Kod.ToUpper();
				
				if (OdKodu != null && DoKodu != null && OdKodu.CompareTo(DoKodu) > 0)
				{
					String tmp = OdKodu; OdKodu = DoKodu; DoKodu = tmp;
				}
			}


			public void EnableFilter(Soneta.Business.View view)
			{
				if (OdKodu != null || DoKodu != null)
					view.FilterCondition += new ConditionHandler(filterProc);
			}


			private void filterProc(object sender, ConditionEventArgs args)
			{
				String pCode = ((RozrachunekIdx)args.Row).Podmiot.Kod.ToUpper();
				args.Accepted &= (OdKodu == null || OdKodu.CompareTo(pCode) <= 0) && (DoKodu == null || pCode.CompareTo(DoKodu) <= 0);
			}


			public String GetTitleString()
			{
				if (OdKodu == null && DoKodu == null)
					return String.Empty;
				else if (OdKodu != null && DoKodu == null)
					return "</strong>Od kontrahenta: <strong>" + HttpUtility.HtmlEncode(OdKodu) + "|";
				else if (OdKodu == null && DoKodu != null)
					return "</strong>Do kontrahenta: <strong>" + HttpUtility.HtmlEncode(DoKodu) + "|";
				else
					return "</strong>Od kontrahenta: <strong>" + HttpUtility.HtmlEncode(OdKodu) + "</strong>, do kontrahenta: <strong>" + HttpUtility.HtmlEncode(DoKodu) + "|";
			}
		}

		
		private Date aktualny;
		private bool należności;
		private String symbol;
		private CustomerSelection customerSelection;

		private ZapisRozrachunkuIdx workerZapisu = new ZapisRozrachunkuIdx();
		private String[] kontaArr = null;
		
		private StanRozliczeniaRozrachunkuWorker worker = null;
		private OdsetkiKarneCalcInfo odsCalcInfo = null;


		void OnContextLoad(object sender, EventArgs e)
		{
			aktualny = pars.Aktualny;
			symbol = pars.Waluta.Symbol.ToUpper();
			należności = pars.Dokumenty == TypDokumentów.Należności;
			customerSelection.Init(pars.Od, pars.Do);

			//
			// -> przygotowanie filtrów kont
			//

			kontaArr = pars.Konto.Trim().Split(new Char[] { ',', ';', '|' }, StringSplitOptions.RemoveEmptyEntries);

			for (int ix = 0; ix < kontaArr.Length; ix++)
				kontaArr[ix] = kontaArr[ix].Trim();
			if (kontaArr.Length == 0 || kontaArr.Length == 1 && kontaArr[0] == String.Empty)
				kontaArr = null;

				KasaModule kasa = KasaModule.GetInstance(dc);
				RozrachunkiIdx rozrachunki = kasa.RozrachunkiIdx;
				Soneta.Business.View view = rozrachunki.Nierozliczone(null, new FromTo(Date.MinValue, aktualny), aktualny);

				RowCondition condition = kasa.RozrachunkiIdx.ZakresEx(
					należności && pars.Rodzaj != RodzajDokumentów.Zapłaty,
					!należności && pars.Rodzaj != RodzajDokumentów.Zapłaty,
					!należności && pars.Rodzaj != RodzajDokumentów.Płatności,
					należności && pars.Rodzaj != RodzajDokumentów.Płatności);
				if (condition != RowCondition.Empty)
					view.Condition &= condition;

				customerSelection.EnableFilter(view);
				view.FilterCondition += new ConditionHandler(WalutaFilter);
				view.FilterCondition += new ConditionHandler(KontoFilter);

				view.Condition &= pars.Condition();
            	view.Condition &= OParams.GetConditionIdx();
			
        	Grid1.DataSource = view;
		        ReportHeader1["ODDZIAL"] = OParams.GetTitleItem();
				ReportHeader1["TYP"] = należności ? "należności" : "zobowiązań";
				ReportHeader1["CUST"] = customerSelection.GetTitleString();
				ReportHeader1["KONTO"] = String.IsNullOrEmpty(pars.Konto.Trim()) ? "(wszystkie)" : pars.Konto;
				ReportHeader1["WALUTA"] = symbol;

				if (pars.Zakres == Zakres.Razem)
					ReportHeader1["ZAKRES"] = "";
				else
					ReportHeader1["ZAKRES"] = "</strong>Zakres: <strong>" + pars.Zakres + "|";

				if (pars.Rodzaj == RodzajDokumentów.Razem)
					ReportHeader1["RODZAJ"] = "";
				else
					ReportHeader1["RODZAJ"] = "</strong>Rodzaj: <strong>" + pars.Rodzaj + "|";

				worker = new StanRozliczeniaRozrachunkuWorker();
				worker.StanRozliczenia = StanRozliczeniaRozrachunku.Nierozliczone;

				odsCalcInfo = OdsetkiKarneCalcInfo.CreateInstance(okPars);
				ColIdOdsetki.Visible = !okPars.CalculationDisabled;
		}


		int viewSort(RozrachunekIdx idx1, RozrachunekIdx idx2)
		{
			int cmp;
			
			if(( cmp= idx1.Podmiot.Kod.CompareTo(idx2.Podmiot.Kod ))!=0)
				return cmp;
			if ((cmp = idx1.Numer.CompareTo(idx2.Numer)) != 0)
				return cmp;

			return 0;
		}


		void WalutaFilter(object sender, ConditionEventArgs args)
		{
			RozrachunekIdx idx = (RozrachunekIdx)args.Row;
			args.Accepted &= idx.Kwota.Symbol == symbol;
		}


		void KontoFilter(object sender, ConditionEventArgs args)
		{
			if (kontaArr == null)
				return;
			if (!args.Accepted)
				return;

			RozrachunekIdx idx = (RozrachunekIdx)args.Row;
			workerZapisu.RozrachunekIdx = idx;

			foreach (String k in kontaArr)
				if (k != String.Empty && Regex.IsMatch(workerZapisu.Konto, GetFilterExpression(k), RegexOptions.CultureInvariant | RegexOptions.IgnoreCase))
					return;

			args.Accepted = false;
		}

		string GetFilterExpression(string mask)
		{ return '^' + mask.Replace("\\", "\\\\").Replace("?", ".?").Replace("*", ".*").Replace("_", ".?").Replace("%", ".*") + '$'; }

		int Zwłoka(RozrachunekIdx idx)
		{
			if (idx.Termin != Date.Empty)
			{
				Date data = Date.Min(idx.DataRozliczenia, aktualny);
				if (idx.Termin < data)
					return data - idx.Termin;
			}
			return 0;
		}


		void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args)
		{
			RozrachunekIdx idx = (RozrachunekIdx)args.Row;

			worker.RozrachunekIdx = idx;

			Currency p = należności ? worker.Naleznosc(aktualny) : worker.Zobowiazanie(aktualny);
			pozostaje.EditValue = p;
			kwotaDokumentu.EditValue = worker.Kwota;

			int z = Zwłoka(idx);
			if (z > 0)
			{
				przeterminowane.EditValue = p;
				zwłoka.EditValue = z;

				if (!okPars.CalculationDisabled)
				{
					odsCalcInfo.SetPodmiot(idx.Podmiot);
					ColIdOdsetki.EditValue = OdsetkiKalkulator.ObliczCalkowiteOdsetki(p, idx.Dokument, odsCalcInfo, aktualny);
				}
			}
		}


		//
		// Zarzadzanie kontekstem
		//


		private WydrukiRozrachunkowSessionProxy sProxy = null;


		private void OnContextLoading(Object sender, EventArgs args)
		{
			sProxy = WydrukiRozrachunkowSessionProxy.GetSingleDbInstance(dc.Context);
			dc.attachContext(sProxy.CloneContext(dc.Context));
		}


		protected override void OnUnload(EventArgs e)
		{
			WydrukiRozrachunkowSessionProxy.SmartDispose(ref sProxy);
			base.OnUnload(e);
		}

		
		
	</script>
</head>
<body>
	<form id="ListaDokumentowNierozliczonych" method="post" runat="server">
	<ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad" OnContextLoading="OnContextLoading" />
	<cc1:ReportHeader ID="ReportHeader1" Title="Lista %TYP% nierozliczonych|%ODDZIAL%</strong>Stan na dzień: <strong>{0}|%RODZAJ%%ZAKRES%%CUST%</strong>Waluta:<strong> %WALUTA%</strong>|Konto: <STRONG>%KONTO%" runat="server" ContextTypeName="Soneta.Business.ActualDate,Soneta.Business" DataMember0="Actual" />
	<ea:SectionMarker ID="SectionMarker2" runat="server" />

	<ea:Grid ID="Grid1" runat="server" RowTypeName="Soneta.Kasa.RozrachunekIdx,Soneta.Kasa"
		OnBeforeRow="Grid1_BeforeRow" GroupData0="Podmiot.Kod" GroupLine="{0}, {1}" ShowGroupSum="True"
		Sort="Podmiot.Kod,Numer" GroupData1="Podmiot.Nazwa" GroupData2="Podmiot" EncodeHTML="true">
		<Columns>
			<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp." />
			<ea:GridColumn runat="server" DataMember="Numer" Caption="Dokument~Numer" NoWrap="True" />
			<ea:GridColumn runat="server" Width="10" Align="Center" DataMember="Data" Caption="Dokument~Data" />
			<ea:GridColumn runat="server" Width="10" Align="Center" DataMember="Termin" Total="Info" Caption="Dokument~Termin" />
			<ea:GridColumn runat="server" Width="4" Align="Right" Caption="Dokument~Zwł." ID="zwłoka" />
			<ea:GridColumn runat="server" Width="15" Align="Right" ID="kwotaDokumentu" Total="Sum" Caption="Dokument~Kwota" Format="{0:n}"/>
			<ea:GridColumn runat="server" Width="15" Align="Right" Total="Sum" Caption="Rozliczenie~Pozostaje" Format="{0:n}" ID="pozostaje" />
			<ea:GridColumn runat="server" Width="15" Align="Right" Total="Sum" Caption="Rozliczenie~Przeterminowane" Format="{0:n}" ID="przeterminowane" />
			<ea:GridColumn runat="server" Width="12" ID="ColIdOdsetki" Align="Right" Total="Sum" Caption="Rozliczenie~Odsetki" Format="{0:n}"  />
		</Columns>
	</ea:Grid>

	<ea:SectionMarker ID="SectionMarker1" runat="server" SectionType="Footer" />
	
	<cc1:ReportFooter ID="ReportFooter1" runat="server">
		<Subtitles>
			<cc1:FooterSubtitle runat="server" SubtitleType="Operator" />
			<cc1:FooterSubtitle runat="server" Caption="Sporządził" SubtitleType="Podpis" />
			<cc1:FooterSubtitle runat="server" Caption="Sprawdził" SubtitleType="Podpis" />
			<cc1:FooterSubtitle runat="server" Caption="Zatwierdził" SubtitleType="Podpis" />
		</Subtitles>
	</cc1:ReportFooter>
	</form>
</body>
</html>

